/*
 * @(#)OMLinkFigure.java  1.0  2. Februar 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.diagram;

import ch.hslu.cm.*;
import ch.hslu.cm.oo.*;
import ch.hslu.cm.simulation.*;
import ch.hslu.cm.oo.objectmodel.*;
import java.io.IOException;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import java.beans.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import java.awt.geom.*;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LabeledLineConnectionFigure;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.draw.decoration.GeneralPathTip;
import org.jhotdraw.draw.layouter.LocatorLayouter;
import org.jhotdraw.draw.locator.BezierLabelLocator;
/**
 * OMLinkFigure visually represents a {@link OMLink}.
 *
 * @author  Werner Randelshofer
 * @version 1.0 2. Februar 2004  Created.
 */
public class OMLinkFigure extends LabeledLineConnectionFigure
implements DiagramFigure, PropertyChangeListener, SimulatedObjectListener {
    private OMLink model;
    private static GeneralPathTip crossTip;
    private static ArrowTip arrowTip = new ArrowTip(Math.PI / 11, 13, 0, false, true, true);
    
    static {
        Path2D.Double cross = new Path2D.Double();
        cross.moveTo(-4, 8);
        cross.lineTo(4, 16);
        cross.moveTo(4,  8);
        cross.lineTo(-4, 16);
        crossTip = new GeneralPathTip(cross, 0, false, true, true);
    }
    
    /** Creates a new instance. */
    public OMLinkFigure() {
        setLayouter(new LocatorLayouter());
        setModel(new OMLink());
        
        setAttributeEnabled(END_DECORATION, false);
        setAttributeEnabled(START_DECORATION, false);
        setAttributeEnabled(STROKE_DASHES, false);
        setAttributeEnabled(FONT_BOLD, false);
        setAttributeEnabled(FONT_ITALIC, false);
        setAttributeEnabled(FONT_UNDERLINE, false);
    }
    
    @Override
    public OMLink getModel() {
        return model;
    }
    
    public void setModel(OMLink m) {
        if (model != null) {
            model.removePropertyChangeListener(this);
            model.removeSimulatedObjectListener(this);
        }
        model = m;
        if (model != null) {
            model.addPropertyChangeListener(this);
            model.addSimulatedObjectListener(this);
        }
        updateLabels();
    }
    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if (model != null) {
            getSimulation().add(model);
        }
    }
    @Override
    public void removeNotify(Drawing drawing) {
        if (getDrawing() != null && getModel() != null) {
            getSimulation().remove(getModel());
        }
        super.removeNotify(drawing);
    }
    
    private void updateLabels() {
        willChange();
        basicRemoveAllChildren();
        
        if (model == null) {
            START_DECORATION.set(this, null);
            END_DECORATION.set(this, null);
        } else {
            if (model.isMemberTraversable()) {
                END_DECORATION.set(this, arrowTip);
                TextFigure memberLabel = new TextFigure(model.getMemberLabel());
                memberLabel.set(LocatorLayouter.LAYOUT_LOCATOR, new BezierLabelLocator(1, Math.PI - Math.PI / 4, 8));
                memberLabel.setEditable(model.getAssociation() == null);
                basicAdd(memberLabel);
            } else {
                END_DECORATION.set(this, null);
            }
        }
        
        layout();
        changed();
    }
    
    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        LinkedList<Action> actions = new LinkedList<Action>();
        
        if (getModel().getAssociation() == null) {
            actions.add(new AbstractAction(model.isMemberTraversable() ? "Mache nicht traversierbar" : "Mache traversierbar") {
    @Override
                public void actionPerformed(ActionEvent event) {
                    model.setMemberTraversable(! model.isMemberTraversable());
                }
            });
        }
        
        return actions;
    }
    
    @Override
    public OMLinkFigure clone() {
        OMLinkFigure that = (OMLinkFigure) super.clone();
        that.setModel((OMLink) this.getModel().clone());
        return that;
    }
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        updateLabels();
    }
    
    private Diagram getDiagram() {
        return (Diagram) getDrawing();
    }
    private Simulation getSimulation() {
        return getDiagram().getSimulation();
    }
    
    /**
     * Handles the disconnection of a connection.
     * Override this method to handle this event.
     */
    protected void handleDisconnect(Figure start, Figure end) {
        model.setEnd(null);
        model.setStart(null);
    }
    
    /**
     * Handles the connection of a connection.
     * Override this method to handle this event.
     */
    protected void handleConnect(Figure start, Figure end) {
        if ((start instanceof DiagramFigure)
        && (end instanceof DiagramFigure)) {
            DiagramFigure sf = (DiagramFigure) start;
            DiagramFigure ef = (DiagramFigure) end;
            
            model.setEnd((SimulatedElement) ef.getModel());
            model.setStart((SimulatedElement) sf.getModel());
        }
    }
    /**
     * Checks if two figures can be connected. Implement this method
     * to constrain the allowed connections between figures.
     */
    public boolean canConnect(Figure start, Figure end) {
        if ((start instanceof DiagramFigure)
        && (end instanceof DiagramFigure)) {
            
            DiagramFigure sf = (DiagramFigure) start;
            DiagramFigure ef = (DiagramFigure) end;
            
            return (start == getStartFigure() && end == getEndFigure())
            || model.canConnect(
                    (SimulatedElement) sf.getModel(), 
                    (SimulatedElement) ef.getModel()
                    );
        }
        
        return false;
    }
    public boolean canConnect(Figure start) {
        if (start instanceof DiagramFigure) {
            DiagramFigure sf = (DiagramFigure) start;
            return model.canConnect((SimulatedElement) sf.getModel());
        }
        return false;
    }
    
    public int getConnectionCount() {
        return 0;
    }
    
    public int getConnectionIndex(DiagramFigure f) {
        return 0;
    }
    @Override
    public void read(DOMInput in) throws IOException {
        in.openElement((in.getElementCount("model") == 1) ? "model" : "Model");
        setModel((OMLink) in.readObject(0));
        in.closeElement();
        readPoints(in);
        readAttributes(in);
    }
    @Override
    public void write(DOMOutput out) throws IOException {
        out.openElement("Model");
        out.writeObject(getModel());
        out.closeElement();
        writePoints(out);
        writeAttributes(out);
    }
    @Override
    public int getLayer() {
        return ClassDiagram.LINK_LAYER;
    }
    
    @Override
    public void objectAdded(SimulatedObjectEvent e) {
    }
    
    @Override
    public void relationshipAdded(SimulatedObjectEvent e) {
    }
    
    @Override
    public void relationshipRemoved(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectChanged(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectRequestRemove(SimulatedObjectEvent e) {
        fireFigureRequestRemove();
    }
    
    @Override
    public void objectRemoved(SimulatedObjectEvent e) {
    }
    
}
